﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VIRP_WEB.BaseCode;
using VIRP_WEB.Controls.Custom.BPR;
using VIRP_WEB.SoaServices;
//using VeteransAffairs.Registries.BusinessAHOBPR;
//using VeteransAffairs.Registries.BusinessManagerAHOBPR;

namespace VIRP_WEB.Custom.BPR.QuestionTool
{
    public partial class ToolQuestionEdit : BprBasePage
    {
        private ServiceInterfaceManager toolManager = new ServiceInterfaceManager();
        ////private AHOBPRShared _sharedManager = new AHOBPRShared();
        //private AHOBPRBaseControlManager _baseControlManager = new AHOBPRBaseControlManager();
        //private List<STD_GUI_CONTROL_AHOBPR> _dbAhopbrControls = null;
        protected override void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
                int questionId = Request.QueryString["id"] == null ? 0 : Helpers.GetIntFromString(Request.QueryString["id"].ToString());
                HiddenFieldQuestionId.Value = questionId.ToString();
                LabelBreadCrumb.Text = questionId == 0 ? "<H1>Follow-up Question Tool >  Add Question</H1>" : "<H1>Tool >  Edit Question</H1>";
                LoadBaseControls();
                LoadControlsFromObject(questionId);
                if (questionId == 0)
                {
                    ButtonSubmitQuestion.Enabled = false;
                }
            }
            Page.PreRender += new EventHandler(Page_PreRender);
        }

        void Page_PreRender(object sender, EventArgs e)
        {
            SetAnswerTextMaxLength();
        }

        private void SetAnswerTextMaxLength()
        {
            TextBox textboxAnswerText = null;
            if (GridViewAnswers.Rows.Count > 0)
            {
                textboxAnswerText = GridViewAnswers.FooterRow.FindControl("TextBoxAnswerText") as TextBox;
            }
            else
            {
                if (GridViewAnswers.Controls.Count > 0)
                {
                    textboxAnswerText = GridViewAnswers.Controls[0].Controls[0].FindControl("TextBoxAnswerTextEmpty") as TextBox;
                }
            }
            if (textboxAnswerText != null)
            {
                if (BaseControlRadioButtonListTextValueQuestionType.Text == "multipleChoice")
                {
                    textboxAnswerText.MaxLength = 100;
                }
                else
                {
                    textboxAnswerText.MaxLength = 4000;
                }
            }
        }

        protected void GridViewAnswers_PreRender(object sender, EventArgs e)
        {
            HookOnFocus(GridViewAnswers);
        }

        private bool ValidateForSave(string questionId)
        {
            bool result = true;

            if (BaseControlRadioButtonListTextValueQuestionType.Text == "multipleChoice")
            {
                TOOL_QUESTION_DTO question = toolManager.GetQuestionById(Helpers.GetIntFromString(questionId));
                if (question != null)
                {
                    if (question.TOOL_ANSWERs.Count() > 0)
                    {
                        List<TOOL_ANSWER_DTO> answers = (from e in question.TOOL_ANSWERs
                                                     where e.TEXT.Length > 100
                                                     select e).ToList();
                        if (answers.Count > 0)
                        {
                            result = false;
                        }
                    }
                }
            }

            return result;
        }

        private bool ValidateForSubmit(string questionId)
        {
            bool result = true;
            string prefix = "Failed to submit question. ";

            TOOL_QUESTION_DTO question = toolManager.GetQuestionById(Helpers.GetIntFromString(questionId));
            if (question != null)
            {
                if (question.TOOL_ANSWERs.Count() == 0)
                {
                    CustomValidatorSubmitQuestion.ErrorMessage = prefix + "At least one answer is required.";
                    result = false;
                }
                else
                {
                    if (question.TYPE == "multiSelect" && question.TOOL_ANSWERs.Count() == 1)
                    {
                        CustomValidatorSubmitQuestion.ErrorMessage = prefix + "More than one answer is required for multi select type.";
                        result = false;
                    }
                    else if (question.TYPE == "multipleChoice")
                    {
                        if (question.TOOL_ANSWERs.Count() == 1)
                        {
                            CustomValidatorSubmitQuestion.ErrorMessage = prefix + "More than one answer is required for multiple choice type.";
                            result = false;
                        }
                        List<TOOL_ANSWER_DTO> answers = (from e in question.TOOL_ANSWERs
                                                     where e.EDITABLE == true
                                                     select e).ToList();
                        if (answers.Count > 0)
                        {
                            CustomValidatorSubmitQuestion.ErrorMessage = prefix + "Please do not include editable answer for dropdown list.";
                            result = false;
                        }
                    }
                    else if (question.TYPE == "number")
                    {
                        List<TOOL_ANSWER_DTO> answers = (from e in question.TOOL_ANSWERs
                                                     where e.EDITABLE == true
                                                     select e).ToList();
                        if (answers.Count == 0)
                        {
                            CustomValidatorSubmitQuestion.ErrorMessage = prefix + "At least one editable answer is required for free text or numeric value type.";
                            result = false;
                        }
                    }
                }
            }

            return result;
        }

        protected void ButtonSubmitQuestion_Click(object sender, EventArgs e)
        {
            CustomValidatorSubmitQuestion.IsValid = true;
            SaveQuestion();

            // Validate that at least one value was entered    
            if (ValidateForSubmit(HiddenFieldQuestionId.Value) == false)
            {
                CustomValidatorSubmitQuestion.IsValid = false;
            }
            else
            {
                //submit the question            
                try
                {
                    TOOL_QUESTION_DTO question = SubmitQuestion();
                    if (question.TOOL_QUESTION_ID > 0)
                    {
                        ButtonSaveQuestion.Enabled = false;
                        ButtonSubmitQuestion.Enabled = false;
                        GridViewAnswers.Enabled = false;
                        Alert.ShowSaveSuccess();
                    }
                    else
                    {
                        Alert.ShowSaveFailed();
                    }
                }
                catch
                {
                    Alert.ShowSaveFailed();
                }
            }
        }

        private int SaveQuestion()
        {
            int questionId = Helpers.GetIntFromString(HiddenFieldQuestionId.Value);

            var question = new TOOL_QUESTION_DTO();
            question.TEXT = BaseControlTextboxQuestionText.Text;
            question.KEY_WORDS = BaseControlTextboxQuestionKeyWords.Text;
            question.TYPE = BaseControlRadioButtonListTextValueQuestionType.Text;
            question.MIN = BaseControlTextBoxMinValue.Text;
            question.MAX = BaseControlTextBoxMaxValue.Text;
            question.EDITABLE_FLAG = true;
            question.ACTIVE_FLAG = false;

            try
            {
                questionId = toolManager.SaveQuestion(User.Identity.Name, questionId, question);

                if (questionId > 0)
                {
                    HiddenFieldQuestionId.Value = questionId.ToString();
                    LoadBaseControls();
                    LoadControlsFromObject(questionId);
                }
                else
                {
                    LoadBaseControls();
                }
            }
            catch
            {
                LoadBaseControls();
            }

            return questionId;
        }

        private TOOL_QUESTION_DTO SubmitQuestion()
        {
            int questionId = Helpers.GetIntFromString(HiddenFieldQuestionId.Value);

            var question = new TOOL_QUESTION_DTO();
            question.EDITABLE_FLAG = false;
            question.ACTIVE_FLAG = true;

            try
            {
                questionId = toolManager.SaveQuestion(User.Identity.Name, questionId, question);

                if (questionId > 0)
                {
                    HiddenFieldQuestionId.Value = questionId.ToString();
                    LoadBaseControls();
                    LoadControlsFromObject(questionId);
                }
                else
                {
                    LoadBaseControls();
                }
            }
            catch
            {
                LoadBaseControls();
            }

            return question;
        }

        protected void GridViewAnswers_RowCommand(object sender, GridViewCommandEventArgs e)
        {
            TextBox textboxAnswerText = null;
            TextBox textboxAnswerHelp = null;
            TextBox textboxOrder = null;
            CheckBox checkboxEditable = null;
            CheckBox checkboxClinicalRelevant = null;
            //int answerId = 0;
            //int saveStatus = 0;

            switch (e.CommandName)
            {
                case "ADD":

                    textboxAnswerText = GridViewAnswers.FooterRow.FindControl("TextBoxAnswerText") as TextBox;
                    textboxAnswerHelp = GridViewAnswers.FooterRow.FindControl("TextboxAnswerHelp") as TextBox;
                    checkboxEditable = GridViewAnswers.FooterRow.FindControl("CheckBoxEditable") as CheckBox;
                    checkboxClinicalRelevant = GridViewAnswers.FooterRow.FindControl("CheckBoxClinicalRelevant") as CheckBox;
                    textboxOrder = GridViewAnswers.FooterRow.FindControl("TextBoxOrder") as TextBox;
                    break;

                case "EMPTYADD":
                    textboxAnswerText = GridViewAnswers.Controls[0].Controls[0].FindControl("TextBoxAnswerTextEmpty") as TextBox;
                    textboxAnswerHelp = GridViewAnswers.Controls[0].Controls[0].FindControl("TextboxAnswerHelpEmpty") as TextBox;
                    checkboxEditable = GridViewAnswers.Controls[0].Controls[0].FindControl("CheckBoxEditableEmpty") as CheckBox;
                    checkboxClinicalRelevant = GridViewAnswers.Controls[0].Controls[0].FindControl("CheckBoxClinicalRelevantEmpty") as CheckBox;
                    textboxOrder = GridViewAnswers.Controls[0].Controls[0].FindControl("TextBoxOrderEmpty") as TextBox;
                    break;

                //case "DELETE_FLAG":
                    //answerId = Convert.ToInt32(e.CommandArgument);
                    //if (_toolManager.RemoveAnswer(answerId))
                    //{
                    //    LoadBaseControls();
                    //    LoadControlsFromObject(Helpers.getIntFromString(HiddenFieldQuestionId.Value));
                    //    Alert.ShowDeleteSuccessful();
                    //}
                    //else
                    //{
                    //    LoadBaseControls();
                    //    Alert.ShowSaveFailed();
                    //}

                    //break;
            }

            //if (e.CommandName.Contains("ADD"))
            //{
            //    if (textboxAnswerText != null && textboxAnswerHelp != null && checkboxEditable != null &&
            //        checkboxClinicalRelevant != null && textboxOrder != null)
            //    {
            //        saveStatus = _toolManager.AddAnswer(textboxAnswerText.Text, textboxAnswerHelp.Text,
            //                                            checkboxEditable.Checked, checkboxClinicalRelevant.Checked,
            //                                            textboxOrder.Text,
            //                                            Helpers.getIntFromString(HiddenFieldQuestionId.Value), false);
            //    }

            //    if (saveStatus == 2)
            //    {
            //        Alert.Show("This answer already exists!");
            //    }
            //    else if (saveStatus == 1)
            //    {
            //        LoadBaseControls();
            //        LoadControlsFromObject(Helpers.getIntFromString(HiddenFieldQuestionId.Value));
            //        Alert.ShowSaveSuccess();
            //    }
            //    else
            //    {
            //        LoadBaseControls();
            //        Alert.ShowSaveFailed();
            //    }
            //}
        }

        //private List<TOOL_ANSWER> GetSelectedAnswers()
        //{
        //    List<TOOL_ANSWER> selectedAnswers = new List<TOOL_ANSWER>();

        //    foreach (GridViewRow row in GridViewAnswers.Rows)
        //    {
        //        if (row.RowType == DataControlRowType.DataRow)
        //        {
        //            string answerId = "";
        //            var foundLabel = (row.Cells[6].FindControl("LabelAnswerID") as Label);
        //            if (foundLabel != null)
        //            {
        //                answerId = foundLabel.Text;
        //            }
        //            string order = "";
        //            var foundTextBox = (row.Cells[1].FindControl("TextBoxOrder") as TextBox);
        //            if (foundTextBox != null)
        //            {
        //                order = foundTextBox.Text;
        //            }
        //            if (!string.IsNullOrEmpty(answerId) && !string.IsNullOrEmpty(order))
        //            {
        //                TOOL_ANSWER item = new TOOL_ANSWER();
        //                item.TOOL_ANSWER_ID = Helpers.getIntFromString(answerId);
        //                item.ORDER = Helpers.getIntFromString(order);

        //                selectedAnswers.Add(item);
        //            }
        //        }
        //    }

        //    return selectedAnswers;
        //}

        protected void GridViewAnswers_RowDeleting(object sender, GridViewDeleteEventArgs e)
        {
            var index = Convert.ToInt32(e.RowIndex);
            GridViewAnswers.SelectedIndex = index;
            var id = Convert.ToInt32(GridViewAnswers.SelectedValue);

            //RaiseDeleteImagingItemEvent(id);

            GridViewAnswers.SelectedIndex = -1;
            GridViewAnswers.Focus();

            //Alert.ShowSaveSuccess();
        }

        /// <summary>
        /// This function goes recursively all child controls and sets 
        /// onfocus attribute if the control has one of defined types.
        /// </summary>
        /// <param name="currentControl">the control to hook.</param>
        private void HookOnFocus(Control currentControl)
        {
            //checks if control is one of TextBox, DropDownList, ListBox or Button

            if ((currentControl is TextBox) ||
                (currentControl is DropDownList) ||
                (currentControl is ListBox) ||
                (currentControl is Button) ||
                (currentControl is Table) ||
                (currentControl is GridView))
            {
                WebControl curr = currentControl as WebControl;
                if (curr != null)
                {
                    //adds a script which saves active control on receiving focus 
                    //in the hidden field __LASTFOCUS.
                    curr.Attributes.Add("onfocus", "try{document.getElementById('__LASTFOCUS').value=this.id; } catch(e) {}");
                }
            }

            //checks if the control has children
            if (currentControl != null && currentControl.HasControls())
                //if yes do them all recursively

                foreach (Control CurrentChildControl in currentControl.Controls)
                    HookOnFocus(CurrentChildControl);
        }

        public void LoadControlsFromObject(int questionId)
        {
            if (questionId > 0)
            {
                var question = toolManager.GetQuestionById(questionId);
                if (question != null)
                {
                    BaseControlTextboxQuestionText.Text = question.TEXT;
                    BaseControlTextboxQuestionKeyWords.Text = question.KEY_WORDS;
                    BaseControlTextBoxMinValue.Text = question.MIN;
                    BaseControlTextBoxMaxValue.Text = question.MAX;
                    BaseControlRadioButtonListTextValueQuestionType.Text = question.TYPE;
                    PanelEditAnswer.Visible = true;
                    var answers = (from e in question.TOOL_ANSWERs
                                   where e.STANDARD_FLAG == false
                                   orderby e.ORDER
                                   select e).ToList();
                    GridViewAnswers.DataSource = answers;
                    GridViewAnswers.DataBind();
                    UserControlToolQuestionPreview.LoadUserControl(questionId);
                    UserControlToolQuestionPreview.LoadControlsFromObject(questionId);
                    PanelPreview.Visible = (answers.Count() > 0);

                    var doNotWish = (from e in question.TOOL_ANSWERs
                                     where e.TEXT == VIRP.AHOBPR.BO.AHOBPRGlobal.StandardAnswerDoNotWish
                                     select e).FirstOrDefault();
                    CheckBoxDoNotWishToAnswer.Checked = (doNotWish != null);

                    var doNotKnow = (from e in question.TOOL_ANSWERs
                                     where e.TEXT == VIRP.AHOBPR.BO.AHOBPRGlobal.StandardAnswerDoNotKnow
                                     select e).FirstOrDefault();
                    CheckBoxDoNotKnow.Checked = (doNotKnow != null);
                    if (GridViewAnswers.FooterRow != null)
                    {
                        TextBox textboxOrder = GridViewAnswers.FooterRow.FindControl("TextBoxOrder") as TextBox;
                        if (textboxOrder != null)
                        {
                            textboxOrder.Text = (answers.Count() + 1).ToString();
                        }
                    }
                }
            }
            else
            {
                PanelEditAnswer.Visible = false;
                PanelPreview.Visible = false;
            }
        }

        private void LoadBaseControls()
        {
            foreach (STD_GUI_CONTROLS dbItem in ServiceInterfaceManager.STD_GUI_CONTROLS_GetByCategory(User.Identity.Name, 16, "AHOBPR_TOOL_QUESTION"))
            {
                Control userControl = this.PanelEditQuestion.FindControl(dbItem.USER_CONTROL_ID);
                if (userControl != null)
                {
                    if (dbItem.BASE_CONTROL_TYPE == (int)VIRP.AHOBPR.BLL.AhobprBaseControlType.CheckBox)
                    {
                        controls_BaseControlCheckBox baseControl = (controls_BaseControlCheckBox)userControl;
                        baseControl.LoadControlsFromObject(false, dbItem.LABEL_TEXT, dbItem.TOOL_TIP, true);
                    }
                    else if (dbItem.BASE_CONTROL_TYPE == (int)VIRP.AHOBPR.BLL.AhobprBaseControlType.TextBox)
                    {
                        controls_BaseControlTextBox baseControl = (controls_BaseControlTextBox)userControl;
                        baseControl.LoadControlsFromObject(string.Empty, dbItem.LABEL_TEXT, dbItem.TOOL_TIP, true, dbItem.DATA_TYPE_MAX_LENGTH, dbItem.DATA_ELEMENT_WIDTH, dbItem.VALIDATION_GROUP, dbItem.VALIDATION_ERROR_MESSAGE, dbItem.VALIDATION_REGULAR_EXPRESSION, dbItem.REQUIRED);
                        if (dbItem.USER_CONTROL_ID == "BaseControlTextboxQuestionText")
                        {
                            baseControl.IsMultiline = true;
                        }
                    }
                    else if (dbItem.BASE_CONTROL_TYPE == (int)VIRP.AHOBPR.BLL.AhobprBaseControlType.RadioButtonListTextValue)
                    {
                        controls_BaseControlRadioButtonListTextValue baseControl = (controls_BaseControlRadioButtonListTextValue)userControl;
                        baseControl.LoadControlsFromObject(string.Empty, dbItem.LABEL_TEXT, dbItem.TOOL_TIP, true, dbItem.LOOKUP_LIST_CATEGORY, dbItem.VALIDATION_GROUP, dbItem.VALIDATION_ERROR_MESSAGE, dbItem.REQUIRED);
                    }
                }
            }
        }

        public override string TopMenuName()
        {
            return "Tool";
        }

        public override string MenuItemName()
        {
            return "Question List";
        }

        public override string AppObjectCode()
        {
            return "AHOBPR TOOL";
        }

        protected void ButtonSaveQuestion_Click(object sender, EventArgs e)
        {
            if (ValidateForSave(HiddenFieldQuestionId.Value) == false)
            {
                Alert.Show("Save Failed. The maximum length for dropdownlist is 100 characters.");
            }
            else
            {
                try
                {
                    var questionId = SaveQuestion();
                    if (questionId > 0)
                    {
                        ButtonSubmitQuestion.Enabled = true;
                        Alert.ShowSaveSuccess();
                    }
                    else
                    {
                        Alert.ShowSaveFailed();
                    }
                }
                catch
                {
                    Alert.ShowSaveFailed();
                }
            }
        }
        protected void ButtonUpdateOrder_Click(object sender, EventArgs e)
        {
            //    bool result = true;
            //    List<TOOL_ANSWER> answers = GetSelectedAnswers();
            //    foreach (TOOL_ANSWER answer in answers)
            //    {
            //        result = _toolManager.UpdateAnswer(answer.TOOL_ANSWER_ID, answer.ORDER);
            //    }
            //    if (result)
            //    {
            //        Alert.ShowSaveSuccess();
            //        LoadControlsFromObject(Helpers.getIntFromString(HiddenFieldQuestionId.Value));
            //    }
            //    else
            //    {
            //        Alert.ShowSaveFailed();
            //    }
        }
        protected void CheckBoxDoNotWishToAnswer_CheckedChanged(object sender, EventArgs e)
        {
            //    if (CheckBoxDoNotWishToAnswer.Checked)
            //    {
            //        _toolManager.AddAnswer(AHOBPRGlobal.StandardAnswerDoNotWish, string.Empty,
            //                                false, false, (GridViewAnswers.Rows.Count + 1).ToString(),
            //                                Helpers.getIntFromString(HiddenFieldQuestionId.Value), true);
            //    }
            //    else
            //    {
            //        _toolManager.RemoveStandardAnswer(Helpers.getIntFromString(HiddenFieldQuestionId.Value), AHOBPRGlobal.StandardAnswerDoNotWish);
            //    }
            //    LoadControlsFromObject(Helpers.getIntFromString(HiddenFieldQuestionId.Value));
        }
        protected void CheckBoxDoNotKnow_CheckedChanged(object sender, EventArgs e)
        {
            //    if (CheckBoxDoNotKnow.Checked)
            //    {
            //        _toolManager.AddAnswer(AHOBPRGlobal.StandardAnswerDoNotKnow, string.Empty,
            //                                false, false, (GridViewAnswers.Rows.Count + 2).ToString(),
            //                                Helpers.getIntFromString(HiddenFieldQuestionId.Value), true);
            //    }
            //    else
            //    {
            //        _toolManager.RemoveStandardAnswer(Helpers.getIntFromString(HiddenFieldQuestionId.Value), AHOBPRGlobal.StandardAnswerDoNotKnow);
            //    }
            //    LoadControlsFromObject(Helpers.getIntFromString(HiddenFieldQuestionId.Value));
        }
    }
}